Attribute VB_Name = "adt856"
Option Explicit
'******************************Basic parameters settings ****************************

Declare Function adt856_initial Lib "adt856.dll" () As Integer
'Function: Initialize motion card
'Return value:Return value is the quantity of ADT-856 cards in the system. Value 3 indiates
'that three cards have been installed and available card numbers are 0, 1 and 2;
'Value 0 indicates that no ADT-856 card has been installed;
'Value -1 indicates that the drivers of ADT-856 card haven't been installed

Declare Function adt856_end Lib "adt856.dll" () As Integer
'Function:Release the resources of motion card
'Return value :        0:correct          1:wrong

Declare Function set_stop0_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'Function :Setup of STOP0 signal valid /invalid and logic electric level
'Parameter:
'cardno    card number
'axis          axis number(1-4)
'value 0: invalid 1: valid
'logic         0:low electric stop    1:high electric stop
'Return value:         0:correct          1:wrong
'Default modes       Signal is invalidlow electric stop
'Notice:
'The way to stop rests on that it is A/D drive or uniform acceleration drive. For former it is A/D stop while for latter instant stop. STOP1 and STOP2 are just the same


Declare Function set_stop1_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'Function :Setup of STOP1 signal valid /invalid and logic electric level
'Parameter:
'cardno    card number
'axis          axis number(1-4)
'value 0: invalid 1: valid
'logic         0:low electric stop    1:high electric stop
'Return value  :       0:correct          1:wrong
'Default modes       Signalinvalidlow electric stop

Declare Function set_stop2_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'Function: Setup of STOP2 signal valid /invalid and logic electric level
'Parameter:
'cardno    card number
'axis          axis number(1-4)
'value 0: invalid 1: valid
'logic         0:low electric stop    1:high electric stop
'Return value  :       0:correct          1:wrong
'Default modes       Signalinvalidlow electric stop
'Notice
'STOP2 signal can clear actual position counter when it is valid. Due to the delay of servo system or mechanical system, error may occur in home position if you clear the actual position counter with software after driving. With this function, you can get higher precision.


Declare Function set_actualcount_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal dir As Integer, ByVal freq As Integer) As Integer
'Function :Set working mode of actual position counte
'Parameter:
'cardno     card number
'axis        axis number(1-4)
'value       Pulse input mode
'0:A/B pulse input
'1:Up/Down (PPIN/PMIN) pulse input
'dir    Counting direction
'0: A leads B or PPIN pulse input up count
'B leads A or PMIN pulse input down count
'1:B leads A or PMIN pulse input up count
'A leads B or PPIN pulse input down count
'freq     Frequency multiplication of A/B pulse input Invalid for Up/Down pulse input
'0: 4     1: 2        2: 1
'Return value  :       0:correct          1:wrong
'Default modes      A/B pulse inputdirection: 0Frequency multiplication: 4

Declare Function set_pulse_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer, ByVal dir_logic As Integer) As Integer
'Function :Set working mode of output pulse
'Parameter:
'cardno       card number
'axis          axis number(1-4)
'value         0:Pulse + Pulse   1:Pulse + Direction
'logic         0:Positive logical pulse      1:Negative logical pulse
'dir-logic   0: Positive direction pulse output
'1:Negative direction pulse output
'Return value :         0:correct          1:wrong
'Default mode    Pulse + direction; positive logical pulse; Positive logic of direction output signal


Declare Function set_limit_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'Function :Set the mode of positive/negative limit input signal nLMT
'Parameter:
'cardno       card number
'axis          axis number(1-4)
'value         0:sudden stop     1:decelerated stop0:sudden stop      1:decelerated stop
'logic         0:low electric valid  1:high electric valid
'Return value :        0:correct         1:wrong
'Default modes       sudden stoplow electric valid
'Notice
'The limit signal can't be valid or invalid.


Declare Function set_softlimit_mode1 Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'Function :Set COMP + register as software limit
'Parameter
'cardno       card number
'axis          axis number(1-4)
'value 0: invalid 1: valid
'Return value         0:correct          1:wrong
'Default modes       invalid
'Notice
'Software limit is always decelerated stop and the counting value may exceed the setting value. It is necessary to consider this point while setting range

Declare Function set_softlimit_mode2 Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'*****************************************************
'Function :Set COMP - register as software limit
'Parameter
'cardno       card number
'axis          axis number(1-4)
'value 0: invalid 1: valid
'Return value         0:correct          1:wrong
'Default modes       invalid
'Notice :The same as above

Declare Function set_softlimit_mode3 Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'Function :set COMP+/- registers as the compare objects of software limit
'Parameter
'cardno       card number
'axis          axis number(1-4)
'value         0:Logical position counter    1:Actual position counter
'Return value         0:correct          1:wrong
'Default modes       Logical position counter
'This function is the comparison object of setting software limit.

Declare Function set_inpos_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'*****Function :Setting of servo in-position signal nINPOS
'Parameter
'cardno       card number
'axis          axis number(1-4)
'value 0: invalid 1: valid
'logic         0:low electricvalid    1:high electricvalid
'Return value         0:correct          1:wrong
'Default modes       invalidlow electricvalid
'Notice
'Do not select valid if nINPOS isn't connected to servo or stepping motor is used.************************************************


Declare Function set_alarm_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'Function :Set the working mode of servo alarm signal nALARM
'Parameter
'cardno       card number
'axis          axis number(1-4)
'value 0: invalid 1: valid
'logic         0:low electric valid      1:high electric valid
'Return value         0:correct             1:wrong
'Default modes       invalidlow electric valid
'Notice
'Do not select valid if nALARM isn't connected to servo or stepping motor is used

Declare Function set_ad_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'Function :Select linear or S-curve acceleration/deceleration
'Parameter
'cardno       card number
'axis          axis number(1-4)
'value         0:linear A/D   1:S-curve A/D
'Return value         0:correct          1:wrong
'Default modes       linear A/D

Declare Function set_dec1_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'Function :Select symmetric or asymmetric acceleration/deceleration
'Parameter
'cardno      card number
'axis         axis number(1-4)
'value       deceleration  mode
'(0: symmetric deceleration, 1: asymmetric deceleration)
'Return value         0:correct          1:wrong
'Default modes       symmetric acceleration/deceleration

Declare Function set_dec2_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'Function :Set deceleration mode
'Parameter
'cardno       card number
'axis          axis number(1-4)
'value         0:automatic deceleration      1: manual deceleration
'Return value         0:correct             1:wrong
'Default modes       Automatic deceleration
'Notice
'Automatic deceleration is used in most cases. To use manual deceleration, it is necessary to set deceleration point


Declare Function set_circle_mode Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'Function :Set the variable circle mode of counter
'Parameter
'cardno       card number
'axis          axis number(1-4)
'value 0: invalid 1: valid
'Return value         0:correct          1:wrong
'Default modes       invalid

Declare Function set_input_filter Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal number As Integer, ByVal value As Integer) As Integer
'Function :Set the filtering function of input signal
'Parameter
'cardno   card number
'    axis         axis number
'    number   Input types
'1:             LMT ?LMT - ?STOP0?STOP1
'2:             STOP2
'3:             nINPOS?nALARM
'4:             nIN
'             Set the filtering state of the four types input signals above
'    value    0: Filtering invalid       1: Filtering valid
'Return value          0:correct          1:wrong
'Default modes       invalid

Declare Function set_filter_time Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'Function :Set the filtering time constant of input signals
'Parameter
'cardno     card number
'axis        axis number
'value      Range: 1-8

'******************************************************
'
'******************* Driving status checking ********************
'
'******************************************************
Declare Function get_status Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, value As Integer) As Integer
'Function:Get the driving status of single axis
'Parameter
'cardno        card number
'axis          axis number(1-4)
'value         Index of driving status; the meanings are:
'0: Driving stopped
'Return value         0:correct          1:wrong
'Notice
'If single axis driving command is executed, you can send next driving instruction to the axis when the driving of corresponding axis is stopped. Otherwise, previous driving instruction stops immediately and next instruction is executed.


Declare Function get_stopdata Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, value As Integer) As Integer
'Function:Get the error stop data of axes
'Parameter
'cardno        card number
'axis          axis number(1-4)
'value          Index of error status
'0:               no Error
'Return value         0:correct          1:wrong

Declare Function get_inp_status Lib "adt856.dll" (ByVal cardno As Integer, ByVal no As Integer, value As Integer) As Integer
'Function:Get the driving status of interpolation
'Parameter
'cardno        card number
'value        Index of interpolation status
'             0: Interpolation stopped   1: Interpolating
'Return value         0:correct          1:wrong
'Notice
'If interpolation driving command is executed, you can send next driving instruction to the axis when the interpolation driving of corresponding axis is stopped. Otherwise, previous driving instruction stops immediately and next instruction is executed.

Declare Function get_inp_status2 Lib "adt856.dll" (ByVal cardno As Integer, ByVal no As Integer, value As Integer) As Integer
'Function:Get the writable status of continuous interpolation
'Parameter
'cardno         card number
'value         Index of writing status
'0: Unwritable 1: Writable
'Return value         0:correct          1:wrong
'Notice
'If the driving is stopped, the status is 0. Threrfore, it is necessary to check whether error occurs in continuous interpolation process.


'*******************************Moving parameter settings*******************************
Declare Function set_range Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:set range
'Parameter
'cardno    card number
'axis          axis number(1-4)
'value range(8000000 - 16000)
'Return value         0:correct          1:wrong

Declare Function set_acac Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the change rate of acceleration/deceleration
'Parameter
'cardno   card number
'axis         axis number(1-4)
'value range(1 - 65535)
'Return value         0:correct          1:wrong

Declare Function set_acc Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the value of acceleration
'Parameter
'cardno   card number
'axis         axis number(1-4)
'value range(1 - 8000)
'Return value         0:correct          1:wrong

Declare Function set_dec Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the value of deceleration
'Parameter
'cardno    card number
'axis          axis number(1-4)
'value d - value(1 - 8000)
'Return value         0:correct          1:wrong

Declare Function set_startv Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the value of start velocity
'Parameter
'cardno    card number
'axis          axis number(1-4)
'value range(1 - 8000)
'Return value         0:correct          1:wrong

Declare Function set_speed Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the value of run velocity
'Parameter
'cardno    card number
'axis          axis number(1-4)
'value range(1 - 8000)
'Return value         0:correct          1:wrong

Declare Function set_command_pos Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the value of logical position counter
'Parameter
'cardno   card number
'axis         axis number(1-4)
'value       range value(-2147483648~+2147483647)
'Return value         0:correct          1:wrong
'Notice
'You can access the logical position counter in real time

Declare Function set_actual_pos Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the value of actual position counter
'Parameter
'cardno    card number
'axis          axis number(1-4)
'value        range value(-2147483648~+2147483647)
'Return value         0:correct          1:wrong
'Notice
'You can access the actual position counter in real time

Declare Function set_comp1 Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the value of COMP+ register
'Parameter
'cardno    card number
'axis          axis number(1-4)
'value        range value(-2147483648~+2147483647)
'Return value         0:correct          1:wrong
'Notice
'You can access the COMP+ register in real time

Declare Function set_comp2 Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the value of COMP- register
'Parameter
'cardno    card number
'axis          axis number(1-4)
'value         range value(-2147483648~+2147483647)
'Return value         0:correct          1:wrong
'Notice
'You can access the COMP- register in real time

Declare Function set_dec_pos Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'Function:Set the value of COMP+ register
'Parameter
'cardno    card number
'axis          axis number(1-4)
'value        range value(0~268435455)
'Return value         0:correct          1:wrong
'Notice
'If manual deceleration mode is used, you need to set manual deceleration point first.Manual deceleration point = output pulses - pulses consumed by deceleration


'*********************** Moving parameter checking ***********************
Declare Function get_command_pos Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, value As Long) As Integer
'Function:Get the logical position of axes
'Parameter
'cardno    card number
'axis          axis number(1-4)
'pos       Index of logical position value
'Return value         0:correct          1:wrong
'Notice
'You can use this function to get the logical position of axes and it can represent the current position of axes if the motor is not out of step

Declare Function get_actual_pos Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, value As Long) As Integer
'Function:Get the actual position of axis
'Parameter
'cardno    card number
'axis          axis number(1-4)
'pos       Index of actual position value
'Return value         0:correct          1:wrong
'Notice:
'You can use this function to get the actual position of axes and you can get the current position of axes even if the motor is out of step.

Declare Function get_speed Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, pos As Long) As Integer
'Function:Get the current driving speed of axes
'Parameter
'cardno    card number
'axis          axis number(1-4)
'speed        Index of current driving speed
'Return value         0:correct          1:wrong
'Notice:Value of actual speed = Getting speed*M = Getting speed*(8000000/R)

Declare Function get_ad Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, pos As Long) As Integer
'Function:Get the current acceleration of axes
'Parameter
'cardno    card number
'axis          axis number(1-4)
'ad           Index of current acceleration
'Return value         0:correct          1:wrong

Declare Function pmove Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long) As Integer
'Function:Single axis quantitative driving
'Parameter
'        cardno      card number
'        axis            axis number(1-4)
'        pulse      output pulses   >0: Positive      <0: Negative
'                    range(-268435455~+268435455)
'Return value         0:correct          1:wrong
'Notice
'You need to set valid speed parameter before writing driving command.

Declare Function continue_move Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal dir As Integer) As Integer
'Function:Single axis continuous driving
'Parameter
'        cardno    card number
'        axis          axis number(1-4)
'        dir      Driving direction   0: Positive     1: Negative
'Return value         0:correct          1:wrong
'    Notice
'You need to set valid speed parameter before writing driving command.

Declare Function dec_stop Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'Function:Stop current driving process in deceleration
'Parameter
'    cardno     card number
'        axis           axis number(1-4)
'Return value         0:correct          1:wrong
'Notice
'This command is decelerated stop in acceleration/deceleration driving, process and sudden stop in constant speed driving process.


Declare Function sudden_stop Lib "adt856.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'Function:Stop current driving process immediately
'Parameter
'cardno    card number
'axis          axis number(1-4)
'Return value         0:correct          1:wrong
'Notice
'Stop pulse output immediately in acceleration/deceleration and constant speed driving process.


Declare Function inp_move2 Lib "adt856.dll" (ByVal cardno As Integer, ByVal no As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer
'Function:Two axes linear interpolation
'Parameter
'cardno    card number
'axis1         Interpolation axis number1(1-4indicate :XYZA)
'axis2      Interpolation axis number2(1-4indicate :XYZA)
'pulse1       Moving distance of axis1
'pulse2         Moving distance of axis2
'Return value         0:correct          1:wrong
'    Notice
'The interpolation speed takes the speed of the axis with smaller axis number between axis1 and axis2 as the standard.


Declare Function inp_cw_arc Lib "adt856.dll" (ByVal cardno As Integer, ByVal no As Integer, ByVal x As Long, ByVal y As Long, ByVal i As Long, ByVal j As Long) As Integer
'Function:Two axes CW arc interpolation
'Parameter
'cardno      card number
'no          1:X-Y    2:Z-W
'x,y        End point position of arc interpolation (relative to start point)
'i,j      Circle center position of arc interpolation (relative to start point)
'Return value         0:correct          1:wrong
'Notice
'The X-Y interpolation takes the speed of X-axis as base,Y-axis do not need to set.
'The Z-W interpolation takes the speed of Z-axis as base,A-axis do not need to set.


Declare Function inp_ccw_arc Lib "adt856.dll" (ByVal cardno As Integer, ByVal no As Integer, ByVal x As Long, ByVal y As Long, ByVal i As Long, ByVal j As Long) As Integer
'Function:Two axes CCW arc interpolation
'Parameter
'cardno    card number
'no          1:X-Y    2:Z-W
'x,y        End point position of arc interpolation (relative to start point)
'i,j      Circle center position of arc interpolation (relative to start point
' Return value         0:correct          1:wrong
'Notice
'The X-Y interpolation takes the speed of X-axis as base,Y-axis do not need to set.
'The Z-W interpolation takes the speed of Z-axis as base,A-axis do not need to set.


Declare Function inp_move3 Lib "adt856.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer
'Function:Three axes linear interpolation
'Parameter
'cardno     card number
'pulse1,pulse2,pulse3        Moving distance of axis X,Y,Z (range:-8388608~+8388607)
'Only X,Y,Z could be used with three axes linear interpolation
'Return value         0:correct          1:wrong
'Notice
'The interpolation speed takes the speed of the axis X as the standard (axis1).the magnification
' and running speed of Z-axis must be the same as X-axis.The start speed of Z-Axis must be the same
' as running speed of X-axis (not start speed),Y-axis do not need to set.


Declare Function inp_move4 Lib "adt856.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long) As Integer
'Function:Four axes linear interpolation
'Parameter
'cardno     card number
'pulse1       Moving distance of X-axis
'pulse2       Moving distance of Y-axis
'pulse3       Moving distance of Z-axis
'pulse4       Moving distance of W-axis
'Return value         0:correct          1:wrong
'Notice
'The interpolation speed takes the speed of the axis X as the standard (axis1).the magnification
'and running speed of Z-axis must be the same as X-axis.The start speed of Z-Axis must be the same
'as running speed of X-axis (not start speed),Y,W-axis do not need to set.

Declare Function inp_move6 Lib "adt856.dll" (ByVal cardno As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long) As Integer
'Function:Four axes linear interpolation
'Parameter
'cardno     card number
'pulse1       Moving distance of axis1
'pulse2       Moving distance of axis2
'pulse3       Moving distance of axis3
'pulse4       Moving distance of axis4
'pulse5       Moving distance of axis5
'pulse6       Moving distance of axis6
'Return value         0:correct          1:wrong
'Notice
'The interpolation speed takes the speed of the axis X as the standard (axis1).the magnification
'and running speed of Z-axis,,U-axis must be the same as X-axis.The start speed of Z-axis,U-axis must be the same
'as running speed of X-axis (not start speed),Y ,W, V axis do not need to set.

Declare Function inp_dec_enable Lib "adt856.dll" (ByVal cardno As Integer, ByVal no As Integer) As Integer
'Function:Enable deceleration of interpolation
'Parameter
'cardno       card number
'Return value         0:correct          1:wrong

Declare Function inp_dec_disable Lib "adt856.dll" (ByVal cardno As Integer, ByVal no As Integer) As Integer
'Function:Disable deceleration of interpolation
'Parameter
'cardno      card number
'Return value         0:correct          1:wrong


Declare Function inp_clear Lib "adt856.dll" (ByVal cardno As Integer) As Integer
'Function:clean the error of interpolation
'Parameter
'cardno      card number
'Return value         0:correct          1:wrong
'********************************************************

'********************* Switch quantity input/output *********************

'*********************************************************
Declare Function read_bit Lib "adt856.dll" (ByVal cardno As Integer, ByVal number As Integer) As Integer
'Function:Get the status of single input bit
'Parameter
'cardno   card number
'number  input bit (0-47)
'Return value         0:low electric     1:high electric  -1:wrong


Declare Function write_bit Lib "adt856.dll" (ByVal cardno As Integer, ByVal number As Integer, ByVal value As Integer) As Integer
'Function:Corresponding port performs output operation.
'Parameter
'cardno    card number
'number    output bit(0-31)
'value 0: low 1: high
'Return value         0:correct          1:wrong



Public Sub MyProc()

    DoEvents

End Sub

